/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;

public class PreventDamageToControllerEffect
extends PreventionEffectImpl {
    public PreventDamageToControllerEffect(Duration duration) {
        this(duration, false, false, Integer.MAX_VALUE);
    }

    public PreventDamageToControllerEffect(Duration duration, int amountToPrevent) {
        this(duration, false, true, amountToPrevent);
    }

    public PreventDamageToControllerEffect(Duration duration, boolean onlyCombat, boolean consumable, int amountToPrevent) {
        super(duration, amountToPrevent, onlyCombat, consumable, null);
        this.staticText = this.setText();
    }

    public PreventDamageToControllerEffect(Duration duration, boolean onlyCombat, boolean consumable, DynamicValue amountToPreventDynamic) {
        super(duration, 0, onlyCombat, consumable, amountToPreventDynamic);
        this.staticText = this.setText();
    }

    protected PreventDamageToControllerEffect(PreventDamageToControllerEffect effect) {
        super(effect);
    }

    @Override
    public PreventDamageToControllerEffect copy() {
        return new PreventDamageToControllerEffect(this);
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        return super.applies(event, source, game) && event.getTargetId().equals(source.getControllerId());
    }

    private String setText() {
        StringBuilder sb = new StringBuilder("prevent ");
        if (this.amountToPrevent == Integer.MAX_VALUE) {
            sb.append("all ");
        } else if (this.amountToPreventDynamic != null) {
            sb.append("the next ").append(this.amountToPreventDynamic.toString()).append(' ');
        } else {
            sb.append("the next ").append(this.amountToPrevent).append(' ');
        }
        if (this.onlyCombat) {
            sb.append("combat ");
        }
        sb.append("damage that would be dealt to you");
        if (this.duration == Duration.EndOfTurn) {
            sb.append(" this turn");
        }
        return sb.toString();
    }
}

