/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;

public class PreventDamageToTargetEffect
extends PreventionEffectImpl {
    public PreventDamageToTargetEffect(Duration duration) {
        this(duration, false);
    }

    public PreventDamageToTargetEffect(Duration duration, boolean onlyCombat) {
        this(duration, Integer.MAX_VALUE, onlyCombat);
    }

    public PreventDamageToTargetEffect(Duration duration, int amount) {
        this(duration, amount, false);
    }

    public PreventDamageToTargetEffect(Duration duration, int amount, boolean onlyCombat) {
        super(duration, amount, onlyCombat);
    }

    public PreventDamageToTargetEffect(Duration duration, boolean onlyCombat, boolean consumable, DynamicValue amountToPreventDynamic) {
        super(duration, 0, onlyCombat, consumable, amountToPreventDynamic);
    }

    protected PreventDamageToTargetEffect(PreventDamageToTargetEffect effect) {
        super(effect);
    }

    @Override
    public PreventDamageToTargetEffect copy() {
        return new PreventDamageToTargetEffect(this);
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        return !this.used && super.applies(event, source, game) && this.getTargetPointer().getTargets(game, source).contains(event.getTargetId());
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder();
        if (this.amountToPrevent == Integer.MAX_VALUE) {
            sb.append("prevent all damage that would be dealt to ");
        } else {
            sb.append("prevent the next ").append(this.amountToPrevent).append(" damage that would be dealt to ");
        }
        sb.append(this.getTargetPointer().describeTargets(mode.getTargets(), "it"));
        if (!this.duration.toString().isEmpty()) {
            sb.append(' ');
            if (this.duration == Duration.EndOfTurn) {
                sb.append("this turn");
            } else {
                sb.append(this.duration.toString());
            }
        }
        return sb.toString();
    }
}

