/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

public class PutIntoLibraryNFromTopTargetEffect
extends OneShotEffect {
    private final int position;

    public PutIntoLibraryNFromTopTargetEffect(int position) {
        super(Outcome.Benefit);
        this.position = position;
    }

    private PutIntoLibraryNFromTopTargetEffect(PutIntoLibraryNFromTopTargetEffect effect) {
        super(effect);
        this.position = effect.position;
    }

    @Override
    public PutIntoLibraryNFromTopTargetEffect copy() {
        return new PutIntoLibraryNFromTopTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        boolean result = false;
        for (UUID permanentId : this.getTargetPointer().getTargets(game, source)) {
            Player player;
            Permanent permanent = game.getPermanent(permanentId);
            if (permanent == null || (player = game.getPlayer(permanent.getOwnerId())) == null) continue;
            result |= player.putCardOnTopXOfLibrary(permanent, game, source, this.position, true);
        }
        return result;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "put " + this.getTargetPointer().describeTargets(mode.getTargets(), "") + " into its owner's library " + CardUtil.numberToOrdinalText(this.position) + " from the top";
    }
}

