/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.game.Game;

public class RemoveAllCountersAllEffect
extends OneShotEffect {
    private final CounterType counterType;
    private final FilterPermanent filter;

    public RemoveAllCountersAllEffect(CounterType counterType, FilterPermanent filter) {
        super(Outcome.Neutral);
        this.counterType = counterType;
        this.filter = filter;
        this.staticText = "remove all " + counterType.getName() + " counters from all " + filter.getMessage();
    }

    protected RemoveAllCountersAllEffect(RemoveAllCountersAllEffect effect) {
        super(effect);
        this.counterType = effect.counterType;
        this.filter = effect.filter;
    }

    @Override
    public RemoveAllCountersAllEffect copy() {
        return new RemoveAllCountersAllEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game).forEach(p -> p.removeAllCounters(this.counterType.getName(), source, game));
        return true;
    }
}

