/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.util.CardUtil;

public class ReturnFromGraveyardToBattlefieldTargetEffect
extends OneShotEffect {
    private final boolean tapped;
    private final boolean attacking;

    public ReturnFromGraveyardToBattlefieldTargetEffect() {
        this(false);
    }

    public ReturnFromGraveyardToBattlefieldTargetEffect(boolean tapped) {
        this(tapped, false);
    }

    public ReturnFromGraveyardToBattlefieldTargetEffect(boolean tapped, boolean attacking) {
        super(Outcome.PutCreatureInPlay);
        this.tapped = tapped;
        this.attacking = attacking;
    }

    protected ReturnFromGraveyardToBattlefieldTargetEffect(ReturnFromGraveyardToBattlefieldTargetEffect effect) {
        super(effect);
        this.tapped = effect.tapped;
        this.attacking = effect.attacking;
    }

    @Override
    public ReturnFromGraveyardToBattlefieldTargetEffect copy() {
        return new ReturnFromGraveyardToBattlefieldTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            HashSet<Card> cardsToMove = new HashSet<Card>();
            for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
                Card card = game.getCard(targetId);
                if (card == null || game.getState().getZone(card.getId()) != Zone.GRAVEYARD) continue;
                cardsToMove.add(card);
            }
            controller.moveCards(cardsToMove, Zone.BATTLEFIELD, source, game, this.tapped, false, false, null);
            if (this.attacking) {
                for (Card card : cardsToMove) {
                    game.getCombat().addAttackingCreature(card.getId(), game);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder();
        boolean yourGrave = !mode.getTargets().isEmpty() && mode.getTargets().get(0) instanceof TargetCardInYourGraveyard;
        sb.append(yourGrave ? "return " : "put ");
        if (mode.getTargets().isEmpty()) {
            sb.append("target creature");
        } else {
            Target target = (Target)mode.getTargets().get(0);
            if (target.getMaxNumberOfTargets() == Integer.MAX_VALUE && target.getMinNumberOfTargets() == 0) {
                sb.append("any number of ");
            } else if (target.getMaxNumberOfTargets() != target.getMinNumberOfTargets()) {
                sb.append("up to ");
                sb.append(CardUtil.numberToText(target.getMaxNumberOfTargets()));
                sb.append(' ');
            } else if (target.getMaxNumberOfTargets() > 1) {
                sb.append(CardUtil.numberToText(target.getMaxNumberOfTargets()));
                sb.append(' ');
            }
            String targetName = ((Target)mode.getTargets().get(0)).getTargetName();
            if (!targetName.contains("target ")) {
                sb.append("target ");
            }
            sb.append(targetName);
        }
        sb.append(yourGrave ? " to" : " onto");
        sb.append(" the battlefield");
        if (!yourGrave) {
            sb.append(" under your control");
        }
        if (this.tapped && this.attacking) {
            sb.append(" tapped and attacking");
        } else if (this.tapped) {
            sb.append(" tapped");
        } else if (this.attacking) {
            sb.append(" attacking");
        }
        return sb.toString();
    }
}

