/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.counters.Counter;
import mage.counters.Counters;
import mage.game.Game;
import mage.util.CardUtil;

public class ReturnFromGraveyardToBattlefieldWithCounterTargetEffect
extends ReturnFromGraveyardToBattlefieldTargetEffect {
    private final Counters counters;
    private final String counterText;

    public ReturnFromGraveyardToBattlefieldWithCounterTargetEffect(Counter ... counters) {
        this(false, counters);
    }

    public ReturnFromGraveyardToBattlefieldWithCounterTargetEffect(boolean additional, Counter ... counters) {
        super(false);
        this.counters = new Counters(new Counter[0]);
        for (Counter counter : counters) {
            this.counters.addCounter(counter);
        }
        this.counterText = ReturnFromGraveyardToBattlefieldWithCounterTargetEffect.makeText(additional, counters);
    }

    protected ReturnFromGraveyardToBattlefieldWithCounterTargetEffect(ReturnFromGraveyardToBattlefieldWithCounterTargetEffect effect) {
        super(effect);
        this.counters = effect.counters.copy();
        this.counterText = effect.counterText;
    }

    @Override
    public ReturnFromGraveyardToBattlefieldWithCounterTargetEffect copy() {
        return new ReturnFromGraveyardToBattlefieldWithCounterTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            game.setEnterWithCounters(targetId, this.counters.copy());
        }
        return super.apply(game, source);
    }

    private static String makeText(boolean additional, Counter ... counters) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Counter counter : counters) {
            StringBuilder sb = new StringBuilder();
            if (counter.getCount() == 1) {
                if (additional) {
                    sb.append("an additional ").append(counter.getName());
                } else {
                    sb.append(CardUtil.addArticle(counter.getName()));
                }
                sb.append(" counter");
            } else {
                sb.append(CardUtil.numberToText(counter.getCount()));
                sb.append(additional ? " additional " : " ");
                sb.append(counter.getName());
                sb.append(" counters");
            }
            strings.add(sb.toString());
        }
        return " with " + CardUtil.concatWithAnd(strings);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return super.getText(mode) + this.counterText + (this.getTargetPointer().isPlural(mode.getTargets()) ? " on them" : " on it");
    }
}

