/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.MeldCard;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.Counters;
import mage.game.Game;
import mage.players.Player;

public class ReturnMORToBattlefieldUnderOwnerControlWithCounterEffect
extends OneShotEffect {
    private final MageObjectReference objectToReturn;
    private final Counters counters;
    private final String counterText;

    public ReturnMORToBattlefieldUnderOwnerControlWithCounterEffect(MageObjectReference objectToReturn, Counter counter, String counterText) {
        this(objectToReturn, new Counters(new Counter[0]).addCounter(counter), counterText);
    }

    public ReturnMORToBattlefieldUnderOwnerControlWithCounterEffect(MageObjectReference objectToReturn, Counters counters, String counterText) {
        super(Outcome.PutCardInPlay);
        this.objectToReturn = objectToReturn;
        this.counters = counters.copy();
        this.counterText = counterText;
        this.staticText = "return that card to the battlefield with " + counterText + " on it";
    }

    private ReturnMORToBattlefieldUnderOwnerControlWithCounterEffect(ReturnMORToBattlefieldUnderOwnerControlWithCounterEffect effect) {
        super(effect);
        this.objectToReturn = effect.objectToReturn;
        this.counters = effect.counters.copy();
        this.counterText = effect.counterText;
    }

    @Override
    public ReturnMORToBattlefieldUnderOwnerControlWithCounterEffect copy() {
        return new ReturnMORToBattlefieldUnderOwnerControlWithCounterEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player owner;
        Card card = game.getCard(this.objectToReturn.getSourceId());
        if (card != null && this.objectToReturn.refersTo(card, game) && (owner = game.getPlayer(card.getOwnerId())) != null) {
            if (card instanceof MeldCard) {
                MeldCard meldCard = (MeldCard)card;
                game.setEnterWithCounters(meldCard.getTopHalfCard().getId(), this.counters);
                game.setEnterWithCounters(meldCard.getBottomHalfCard().getId(), this.counters);
            } else {
                game.setEnterWithCounters(this.objectToReturn.getSourceId(), this.counters);
            }
            owner.moveCards(card, Zone.BATTLEFIELD, source, game, false, false, true, null);
        }
        return true;
    }
}

