/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.MeldCard;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

public class ReturnToBattlefieldUnderOwnerControlTargetEffect
extends OneShotEffect {
    private final boolean tapped;
    private final boolean returnFromExileZoneOnly;

    public ReturnToBattlefieldUnderOwnerControlTargetEffect(boolean tapped, boolean returnFromExileZoneOnly) {
        super(Outcome.Benefit);
        this.tapped = tapped;
        this.returnFromExileZoneOnly = returnFromExileZoneOnly;
        this.staticText = "return that card to the battlefield " + (tapped ? "tapped " : "") + "under its owner's control";
    }

    protected ReturnToBattlefieldUnderOwnerControlTargetEffect(ReturnToBattlefieldUnderOwnerControlTargetEffect effect) {
        super(effect);
        this.tapped = effect.tapped;
        this.returnFromExileZoneOnly = effect.returnFromExileZoneOnly;
    }

    @Override
    public ReturnToBattlefieldUnderOwnerControlTargetEffect copy() {
        return new ReturnToBattlefieldUnderOwnerControlTargetEffect(this);
    }

    protected Cards getCardsToReturn(Game game, Ability source) {
        CardsImpl cardsToBattlefield = new CardsImpl();
        if (this.returnFromExileZoneOnly) {
            for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
                if (game.getExile().containsId(targetId, game)) {
                    cardsToBattlefield.add(targetId);
                    continue;
                }
                Card card = game.getCard(targetId);
                if (!(card instanceof MeldCard)) continue;
                MeldCard meldCard = (MeldCard)card;
                Card topCard = meldCard.getTopHalfCard();
                Card bottomCard = meldCard.getBottomHalfCard();
                if (topCard.getZoneChangeCounter(game) == meldCard.getTopLastZoneChangeCounter() && game.getExile().containsId(topCard.getId(), game)) {
                    cardsToBattlefield.add(topCard);
                }
                if (bottomCard.getZoneChangeCounter(game) != meldCard.getBottomLastZoneChangeCounter() || !game.getExile().containsId(bottomCard.getId(), game)) continue;
                cardsToBattlefield.add(bottomCard);
            }
        } else {
            cardsToBattlefield.addAll(this.getTargetPointer().getTargets(game, source));
        }
        return cardsToBattlefield;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Cards cardsToBattlefield = this.getCardsToReturn(game, source);
        if (!cardsToBattlefield.isEmpty()) {
            controller.moveCards(cardsToBattlefield.getCards(game), Zone.BATTLEFIELD, source, game, this.tapped, false, true, null);
        }
        return true;
    }
}

