/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

public class ReturnToLibrarySpellEffect
extends OneShotEffect {
    private final boolean toTop;

    public ReturnToLibrarySpellEffect(boolean top) {
        super(Outcome.Neutral);
        this.staticText = "Put {this} on " + (top ? "top" : "the bottom") + " of its owner's library";
        this.toTop = top;
    }

    protected ReturnToLibrarySpellEffect(ReturnToLibrarySpellEffect effect) {
        super(effect);
        this.toTop = effect.toTop;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card spellCard;
            Spell spell = game.getStack().getSpell(source.getSourceId());
            if (spell != null && (spellCard = spell.getCard()) != null) {
                controller.moveCardToLibraryWithInfo(spellCard, source, game, Zone.STACK, this.toTop, true);
            }
            return true;
        }
        return false;
    }

    @Override
    public ReturnToLibrarySpellEffect copy() {
        return new ReturnToLibrarySpellEffect(this);
    }
}

