/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.Set;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class RevealLibraryPutIntoHandEffect
extends OneShotEffect {
    private DynamicValue amountCards;
    private FilterCard filter;
    private Zone zoneToPutRest;
    private boolean anyOrder;

    public RevealLibraryPutIntoHandEffect(int amountCards, FilterCard filter, Zone zoneToPutRest) {
        this(amountCards, filter, zoneToPutRest, true);
    }

    public RevealLibraryPutIntoHandEffect(int amountCards, FilterCard filter, Zone zoneToPutRest, boolean anyOrder) {
        this(StaticValue.get(amountCards), filter, zoneToPutRest, anyOrder);
    }

    public RevealLibraryPutIntoHandEffect(DynamicValue amountCards, FilterCard filter, Zone zoneToPutRest, boolean anyOrder) {
        super(Outcome.DrawCard);
        this.amountCards = amountCards;
        this.filter = filter;
        this.zoneToPutRest = zoneToPutRest;
        this.anyOrder = anyOrder;
        this.staticText = this.setText();
    }

    protected RevealLibraryPutIntoHandEffect(RevealLibraryPutIntoHandEffect effect) {
        super(effect);
        this.amountCards = effect.amountCards;
        this.filter = effect.filter;
        this.zoneToPutRest = effect.zoneToPutRest;
        this.anyOrder = effect.anyOrder;
    }

    @Override
    public RevealLibraryPutIntoHandEffect copy() {
        return new RevealLibraryPutIntoHandEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller == null || sourceObject == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        cards.addAllCards(controller.getLibrary().getTopCards(game, this.amountCards.calculate(game, source, this)));
        controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
        Set<Card> cardsList = cards.getCards(game);
        CardsImpl cardsToHand = new CardsImpl();
        for (Card card : cardsList) {
            if (!this.filter.match(card, controller.getId(), source, game)) continue;
            cardsToHand.add(card);
            cards.remove(card);
        }
        controller.moveCards(cardsToHand, Zone.HAND, source, game);
        switch (this.zoneToPutRest) {
            case LIBRARY: {
                controller.putCardsOnBottomOfLibrary(cards, game, source, this.anyOrder);
                break;
            }
            default: {
                controller.moveCards(cards, this.zoneToPutRest, source, game);
            }
        }
        return true;
    }

    private String setText() {
        StringBuilder sb = new StringBuilder("reveal the top ");
        sb.append(CardUtil.numberToText(this.amountCards.toString())).append(" cards of your library. Put all ");
        sb.append(this.filter.getMessage());
        sb.append(" revealed this way into your hand and the rest ");
        switch (this.zoneToPutRest) {
            case LIBRARY: {
                sb.append("on the bottom of your library");
                if (this.anyOrder) {
                    sb.append(" in any order");
                    break;
                }
                sb.append(" in a random order");
                break;
            }
            case GRAVEYARD: {
                sb.append("into your graveyard");
            }
        }
        return sb.toString();
    }
}

