/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class SacrificeTargetEffect
extends OneShotEffect {
    protected UUID playerIdThatHasToSacrifice;

    public SacrificeTargetEffect() {
        this("");
    }

    public SacrificeTargetEffect(String text) {
        this(text, null);
    }

    public SacrificeTargetEffect(String text, UUID playerIdThatHasToSacrifice) {
        super(Outcome.Sacrifice);
        this.playerIdThatHasToSacrifice = playerIdThatHasToSacrifice;
        this.staticText = text;
    }

    protected SacrificeTargetEffect(SacrificeTargetEffect effect) {
        super(effect);
        this.playerIdThatHasToSacrifice = effect.playerIdThatHasToSacrifice;
    }

    @Override
    public SacrificeTargetEffect copy() {
        return new SacrificeTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        int affectedTargets = 0;
        for (UUID permanentId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(permanentId);
            if (permanent == null || this.playerIdThatHasToSacrifice != null && !this.playerIdThatHasToSacrifice.equals(permanent.getControllerId())) continue;
            permanent.sacrifice(source, game);
            ++affectedTargets;
        }
        return affectedTargets > 0;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return this.getTargetPointer().describeTargets(mode.getTargets(), "that permanent") + "'s controller sacrifices it";
    }
}

