/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

public class ShuffleIntoLibrarySourceEffect
extends OneShotEffect {
    public ShuffleIntoLibrarySourceEffect() {
        super(Outcome.Neutral);
        this.staticText = "shuffle it into its owner's library";
    }

    protected ShuffleIntoLibrarySourceEffect(ShuffleIntoLibrarySourceEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        MageObject mageObject = source.getSourceObjectIfItStillExists(game);
        if (mageObject != null) {
            Player owner;
            Zone fromZone = game.getState().getZone(mageObject.getId());
            if (mageObject instanceof Permanent) {
                Player owner2 = game.getPlayer(((Permanent)mageObject).getOwnerId());
                if (owner2 != null) {
                    owner2.moveCardToLibraryWithInfo((Permanent)mageObject, source, game, fromZone, true, true);
                    owner2.shuffleLibrary(source, game);
                    return true;
                }
            } else if (mageObject instanceof Card && (owner = game.getPlayer(((Card)mageObject).getOwnerId())) != null) {
                owner.moveCardToLibraryWithInfo((Card)mageObject, source, game, fromZone, true, true);
                owner.shuffleLibrary(source, game);
                return true;
            }
        }
        return false;
    }

    @Override
    public ShuffleIntoLibrarySourceEffect copy() {
        return new ShuffleIntoLibrarySourceEffect(this);
    }
}

