/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

public class ShuffleIntoLibraryTargetEffect
extends OneShotEffect {
    boolean optional;

    public ShuffleIntoLibraryTargetEffect() {
        this(false);
    }

    public ShuffleIntoLibraryTargetEffect(boolean optional) {
        super(Outcome.Detriment);
        this.optional = optional;
    }

    protected ShuffleIntoLibraryTargetEffect(ShuffleIntoLibraryTargetEffect effect) {
        super(effect);
        this.optional = effect.optional;
    }

    @Override
    public ShuffleIntoLibraryTargetEffect copy() {
        return new ShuffleIntoLibraryTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection<UUID>)this.getTargetPointer().getTargets(game, source));
        if (cards.isEmpty()) {
            return true;
        }
        if (this.optional && !controller.chooseUse(Outcome.Benefit, "Shuffle the target card" + (cards.size() > 1 ? "s" : "") + " into your library?", source, game)) {
            return true;
        }
        HashMap<UUID, Cards> cardsByOwner = new HashMap<UUID, Cards>();
        for (Card card : cards.getCards(game)) {
            cardsByOwner.computeIfAbsent(card.getOwnerId(), x -> new CardsImpl()).add(card);
        }
        for (Map.Entry entry : cardsByOwner.entrySet()) {
            Player owner = game.getPlayer((UUID)entry.getKey());
            if (owner == null) continue;
            owner.shuffleCardsToLibrary((Cards)entry.getValue(), game, source);
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        String targetDescription = this.getTargetPointer().describeTargets(mode.getTargets(), "");
        if (targetDescription.contains("your graveyard")) {
            return (this.optional ? "you may shuffle " : "shuffle ") + targetDescription + " into your library";
        }
        return "choose " + targetDescription + (this.getTargetPointer().isPlural(mode.getTargets()) ? ". The owners of those cards shuffle them into their libraries" : ". Its owner shuffles it into their library");
    }
}

