/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.MageSingleton;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

public class ShuffleSpellEffect
extends OneShotEffect
implements MageSingleton {
    private static final ShuffleSpellEffect instance = new ShuffleSpellEffect();

    public static ShuffleSpellEffect getInstance() {
        return instance;
    }

    private ShuffleSpellEffect() {
        super(Outcome.Neutral);
        this.staticText = "Shuffle {this} into its owner's library";
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player owner;
            Spell spell = game.getStack().getSpell(source.getId());
            if (spell != null && controller.moveCards(spell, Zone.LIBRARY, source, game) && (owner = game.getPlayer(spell.getCard().getOwnerId())) != null) {
                owner.shuffleLibrary(source, game);
            }
            return true;
        }
        return false;
    }

    @Override
    public ShuffleSpellEffect copy() {
        return instance;
    }
}

