/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

public class SkipUntapOptionalSourceEffect
extends RestrictionEffect {
    public SkipUntapOptionalSourceEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "You may choose not to untap {this} during your untap step";
    }

    protected SkipUntapOptionalSourceEffect(SkipUntapOptionalSourceEffect effect) {
        super(effect);
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(source.getSourceId()) && permanent.isControlledBy(game.getActivePlayerId()) && permanent.isTapped();
    }

    @Override
    public boolean canBeUntapped(Permanent permanent, Ability source, Game game, boolean canUseChooseDialogs) {
        Player player = game.getPlayer(permanent.getControllerId());
        if (canUseChooseDialogs) {
            return player != null && player.chooseUse(Outcome.Benefit, "Untap " + permanent.getLogName() + '?', source, game);
        }
        return true;
    }

    @Override
    public SkipUntapOptionalSourceEffect copy() {
        return new SkipUntapOptionalSourceEffect(this);
    }
}

