/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.AbilityType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

public class TapSourceUnlessPaysEffect
extends OneShotEffect {
    protected Cost cost;

    public TapSourceUnlessPaysEffect(Cost cost) {
        super(Outcome.Tap);
        this.cost = cost;
        this.staticText = "tap {this} unless you " + CardUtil.addCostVerb(cost.getText());
    }

    protected TapSourceUnlessPaysEffect(TapSourceUnlessPaysEffect effect) {
        super(effect);
        this.cost = effect.cost.copy();
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null && source.getAbilityType() == AbilityType.STATIC) {
            permanent = game.getPermanentEntering(source.getSourceId());
        }
        if (player != null && permanent != null) {
            if (this.cost.canPay(source, source, source.getControllerId(), game) && player.chooseUse(Outcome.Benefit, this.cost.getText() + "? (otherwise " + permanent.getName() + " becomes tapped)", source, game)) {
                this.cost.clearPaid();
                if (this.cost.pay(source, game, source, source.getControllerId(), false, null)) {
                    return true;
                }
            }
            permanent.tap(source, game);
            return true;
        }
        return false;
    }

    @Override
    public TapSourceUnlessPaysEffect copy() {
        return new TapSourceUnlessPaysEffect(this);
    }
}

