/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.RemoveDelayedTriggeredAbilityEffect;
import mage.abilities.effects.common.RemoveSpecialActionEffect;
import mage.abilities.effects.common.UnlessPaysDelayedEffectAction;
import mage.abilities.effects.common.UnlessPaysDelayedEffectTriggeredAbility;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.target.targetpointer.FixedTarget;

public class UnlessPaysDelayedEffect
extends OneShotEffect {
    private final Cost cost;
    private final Effect effect;
    private final PhaseStep step;
    private final boolean affectedPlayersTurn;

    public UnlessPaysDelayedEffect(Cost cost, Effect effect, PhaseStep step, boolean affectedPlayersTurn, String text) {
        super(Outcome.Detriment);
        this.cost = cost;
        this.effect = effect;
        this.step = step;
        this.affectedPlayersTurn = affectedPlayersTurn;
        this.staticText = text + "<br><i>Use the Special button to pay the " + cost.getText() + " with a special action before that step.</i>";
    }

    protected UnlessPaysDelayedEffect(UnlessPaysDelayedEffect effect) {
        super(effect);
        this.cost = effect.cost.copy();
        this.effect = effect.effect.copy();
        this.step = effect.step;
        this.affectedPlayersTurn = effect.affectedPlayersTurn;
    }

    @Override
    public UnlessPaysDelayedEffect copy() {
        return new UnlessPaysDelayedEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = source.getSourceObject(game);
        if (sourceObject != null) {
            UnlessPaysDelayedEffectAction newAction = new UnlessPaysDelayedEffectAction();
            UUID turnPlayer = this.affectedPlayersTurn ? this.getTargetPointer().getFirst(game, source) : source.getControllerId();
            this.effect.setTargetPointer(new FixedTarget(this.getTargetPointer().getFirst(game, source)));
            UnlessPaysDelayedEffectTriggeredAbility delayedAbility = new UnlessPaysDelayedEffectTriggeredAbility(turnPlayer, this.step, this.effect);
            delayedAbility.setSpecialActionId(newAction.getId());
            UUID delayedAbilityId = game.addDelayedTriggeredAbility(delayedAbility, source);
            newAction.addCost(this.cost);
            RemoveDelayedTriggeredAbilityEffect removeEffect = new RemoveDelayedTriggeredAbilityEffect(delayedAbilityId);
            newAction.addEffect(removeEffect);
            newAction.addEffect(new RemoveSpecialActionEffect(newAction.getId()));
            newAction.setSourceId(source.getSourceId());
            newAction.setControllerId(this.getTargetPointer().getFirst(game, source));
            removeEffect.setText(sourceObject.getIdName() + " - Pay " + this.cost.getText() + " to remove the triggered ability.");
            game.getState().getSpecialActions().add(newAction);
            return true;
        }
        return false;
    }
}

