/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.AttachmentType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class UntapAttachedEffect
extends OneShotEffect {
    public UntapAttachedEffect() {
        this(AttachmentType.AURA, "creature");
    }

    public UntapAttachedEffect(AttachmentType attachmentType, String name) {
        super(Outcome.Untap);
        this.staticText = "untap " + CardUtil.getTextWithFirstCharLowerCase(attachmentType.verb()) + ' ' + name;
    }

    protected UntapAttachedEffect(UntapAttachedEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent attach;
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (permanent != null && (attach = game.getPermanent(permanent.getAttachedTo())) != null) {
            attach.untap(game);
            return true;
        }
        return false;
    }

    @Override
    public UntapAttachedEffect copy() {
        return new UntapAttachedEffect(this);
    }
}

