/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class UntapTargetEffect
extends OneShotEffect {
    public UntapTargetEffect() {
        this((String)null);
    }

    public UntapTargetEffect(String text) {
        super(Outcome.Untap);
        if (text != null) {
            this.staticText = text;
        }
    }

    protected UntapTargetEffect(UntapTargetEffect effect) {
        super(effect);
    }

    @Override
    public UntapTargetEffect copy() {
        return new UntapTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        for (UUID target : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(target);
            if (permanent == null) continue;
            permanent.untap(game);
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "untap " + this.getTargetPointer().describeTargets(mode.getTargets(), "that permanent");
    }
}

