/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.List;
import java.util.Set;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

public class WishEffect
extends OneShotEffect {
    private final FilterCard filter;
    private final boolean reveal;
    private final boolean alsoFromExile;
    private final boolean topOfLibrary;
    private final String choiceText;

    public WishEffect() {
        this(false);
    }

    public WishEffect(boolean topOfLibrary) {
        super(Outcome.DrawCard);
        this.filter = StaticFilters.FILTER_CARD;
        this.reveal = false;
        this.alsoFromExile = false;
        this.topOfLibrary = topOfLibrary;
        this.choiceText = "Put a card you own from outside the game " + (topOfLibrary ? "on top of your library?" : "into your hand?");
        this.staticText = "You may " + Character.toLowerCase(this.choiceText.charAt(0)) + this.choiceText.substring(1, this.choiceText.length() - 1);
    }

    public WishEffect(FilterCard filter) {
        this(filter, false);
    }

    public WishEffect(FilterCard filter, boolean alsoFromExile) {
        this(filter, alsoFromExile, false);
    }

    public WishEffect(FilterCard filter, boolean alsoFromExile, boolean topOfLibrary) {
        super(Outcome.DrawCard);
        this.filter = filter;
        this.reveal = true;
        this.alsoFromExile = alsoFromExile;
        this.topOfLibrary = topOfLibrary;
        this.choiceText = "Reveal " + CardUtil.addArticle(filter.getMessage()) + " you own from outside the game " + (alsoFromExile ? "or choose " + WishEffect.makeExileText(filter) + " you own in exile. Put that card" : "and put it") + (topOfLibrary ? " on top of your library?" : " into your hand?");
        this.staticText = "You may " + Character.toLowerCase(this.choiceText.charAt(0)) + this.choiceText.substring(1, this.choiceText.length() - 1);
    }

    private static String makeExileText(FilterCard filter) {
        String s = filter.getMessage();
        if (s.startsWith("a ")) {
            return s.replace("a ", "a face-up ");
        }
        if (s.startsWith("an ")) {
            return s.replace("an ", "a face-up ");
        }
        return "a face-up " + s;
    }

    protected WishEffect(WishEffect effect) {
        super(effect);
        this.filter = effect.filter;
        this.reveal = effect.reveal;
        this.alsoFromExile = effect.alsoFromExile;
        this.topOfLibrary = effect.topOfLibrary;
        this.choiceText = effect.choiceText;
    }

    @Override
    public WishEffect copy() {
        return new WishEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        boolean noTargets;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        if (!controller.chooseUse(Outcome.Benefit, this.choiceText, source, game)) {
            return false;
        }
        Cards cards = controller.getSideboard();
        List<Card> exile = game.getExile().getCardsOwned(game, controller.getId());
        boolean bl = noTargets = cards.isEmpty() && (!this.alsoFromExile || exile.isEmpty());
        if (noTargets) {
            game.informPlayer(controller, "You have no cards outside the game" + (this.alsoFromExile ? " or in exile" : "") + '.');
            return true;
        }
        Set<Card> filtered = cards.getCards(this.filter, game);
        CardsImpl filteredCards = new CardsImpl();
        for (Card card : filtered) {
            filteredCards.add(card.getId());
        }
        if (this.alsoFromExile) {
            for (Card exileCard : exile) {
                if (!exileCard.isOwnedBy(source.getControllerId()) || !this.filter.match(exileCard, game)) continue;
                filteredCards.add(exileCard);
            }
        }
        if (filteredCards.isEmpty()) {
            game.informPlayer(controller, "You don't have " + this.filter.getMessage() + " outside the game" + (this.alsoFromExile ? " or in exile" : "") + '.');
            return true;
        }
        TargetCard target = new TargetCard(Zone.ALL, this.filter);
        target.withNotTarget(true);
        if (controller.choose(Outcome.PutCardInPlay, filteredCards, target, source, game)) {
            Card card;
            card = controller.getSideboard().get(target.getFirstTarget(), game);
            if (card == null && this.alsoFromExile) {
                card = game.getCard(target.getFirstTarget());
            }
            if (card != null) {
                if (this.topOfLibrary) {
                    controller.putCardsOnTopOfLibrary(card, game, source, true);
                } else {
                    controller.moveCards(card, Zone.HAND, source, game);
                }
                if (this.reveal) {
                    CardsImpl revealCard = new CardsImpl();
                    revealCard.add(card);
                    controller.revealCards(sourceObject.getIdName(), (Cards)revealCard, game);
                }
            }
        }
        return true;
    }
}

