/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class AddCardSubTypeSourceEffect
extends ContinuousEffectImpl {
    private final boolean inAddition;
    private final List<SubType> addedSubTypes = new ArrayList<SubType>();

    public AddCardSubTypeSourceEffect(Duration duration, SubType ... addedSubType) {
        this(duration, false, addedSubType);
    }

    public AddCardSubTypeSourceEffect(Duration duration, boolean inAddition, SubType ... addedSubType) {
        super(duration, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        this.inAddition = inAddition;
        this.addedSubTypes.addAll(Arrays.asList(addedSubType));
    }

    private AddCardSubTypeSourceEffect(AddCardSubTypeSourceEffect effect) {
        super(effect);
        this.inAddition = effect.inAddition;
        this.addedSubTypes.addAll(effect.addedSubTypes);
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        this.affectedObjectList.add(new MageObjectReference(source.getSourceId(), game));
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && this.affectedObjectList.contains(new MageObjectReference(permanent, game))) {
            if (!this.inAddition) {
                permanent.removeAllCreatureTypes(game);
            }
            for (SubType cardType : this.addedSubTypes) {
                permanent.addSubType(game, cardType);
            }
            return true;
        }
        if (this.getDuration() == Duration.Custom) {
            this.discard();
        }
        return false;
    }

    @Override
    public AddCardSubTypeSourceEffect copy() {
        return new AddCardSubTypeSourceEffect(this);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        String subTypeText = this.addedSubTypes.stream().map(SubType::toString).collect(Collectors.joining(" "));
        return "{this} becomes " + CardUtil.addArticle(subTypeText) + (this.inAddition ? " in addition to its other types" : "") + (this.duration.toString().isEmpty() ? "" : ' ' + this.duration.toString());
    }
}

