/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class AddCardSubtypeAllEffect
extends ContinuousEffectImpl {
    private final FilterPermanent filter;
    private final SubType addedSubtype;

    public AddCardSubtypeAllEffect(FilterPermanent filter, SubType addedSubtype, DependencyType dependency) {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        this.filter = filter;
        this.addedSubtype = addedSubtype;
        this.staticText = filter.getMessage() + " are " + addedSubtype.getPluralName() + " in addition to their other types";
        this.addDependencyType(dependency);
    }

    protected AddCardSubtypeAllEffect(AddCardSubtypeAllEffect effect) {
        super(effect);
        this.filter = effect.filter;
        this.addedSubtype = effect.addedSubtype;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        for (Permanent perm : game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game)) {
            perm.addSubType(game, this.addedSubtype);
        }
        return true;
    }

    @Override
    public AddCardSubtypeAllEffect copy() {
        return new AddCardSubtypeAllEffect(this);
    }
}

