/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class AddCreatureTypeAdditionEffect
extends ContinuousEffectImpl {
    private final SubType subType;
    private final boolean giveBlackColor;

    public AddCreatureTypeAdditionEffect(SubType subType, boolean giveBlackColor) {
        super(Duration.Custom, Outcome.Neutral);
        this.subType = subType;
        this.giveBlackColor = giveBlackColor;
        this.updateText();
    }

    protected AddCreatureTypeAdditionEffect(AddCreatureTypeAdditionEffect effect) {
        super(effect);
        this.subType = effect.subType;
        this.giveBlackColor = effect.giveBlackColor;
    }

    private void updateText() {
        this.staticText = this.giveBlackColor ? "That creature is a black " + (Object)((Object)this.subType) + " in addition to its other colors and types" : "That creature is a " + (Object)((Object)this.subType) + " in addition to its other types";
    }

    @Override
    public boolean hasLayer(Layer layer) {
        return layer == Layer.ColorChangingEffects_5 || layer == Layer.TypeChangingEffects_4;
    }

    @Override
    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent creature;
        if (source.getTargets().getFirstTarget() == null) {
            creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        } else {
            creature = game.getPermanent(source.getTargets().getFirstTarget());
            if (creature == null) {
                creature = game.getPermanentEntering(source.getTargets().getFirstTarget());
            }
        }
        if (creature == null) {
            this.used = true;
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                creature.addSubType(game, this.subType);
                break;
            }
            case ColorChangingEffects_5: {
                if (!this.giveBlackColor) break;
                creature.getColor(game).setBlack(true);
            }
        }
        return true;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return false;
    }

    @Override
    public AddCreatureTypeAdditionEffect copy() {
        return new AddCreatureTypeAdditionEffect(this);
    }
}

