/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureTypeTargetEffect;
import mage.cards.Card;
import mage.choices.ChoiceCreatureType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;

public class BecomesChosenCreatureTypeTargetEffect
extends OneShotEffect {
    private final boolean nonWall;
    private final Duration duration;

    public BecomesChosenCreatureTypeTargetEffect() {
        this(false, Duration.EndOfTurn);
    }

    public BecomesChosenCreatureTypeTargetEffect(boolean nonWall) {
        this(nonWall, Duration.EndOfTurn);
    }

    public BecomesChosenCreatureTypeTargetEffect(boolean nonWall, Duration duration) {
        super(Outcome.BoostCreature);
        this.nonWall = nonWall;
        this.duration = duration;
        this.staticText = nonWall ? "choose a creature type other than Wall. Target creature becomes that type until end of turn" : "target creature becomes the creature type of your choice until end of turn";
    }

    protected BecomesChosenCreatureTypeTargetEffect(BecomesChosenCreatureTypeTargetEffect effect) {
        super(effect);
        this.nonWall = effect.nonWall;
        this.duration = effect.duration;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getSourceId());
        String chosenType = "";
        if (player != null && card != null) {
            ChoiceCreatureType typeChoice = new ChoiceCreatureType(game, source);
            String msg = "Choose a creature type";
            if (this.nonWall) {
                msg = msg + " other than Wall";
            }
            typeChoice.setMessage(msg);
            if (this.nonWall) {
                typeChoice.getKeyChoices().remove(SubType.WALL.getDescription());
            }
            if (!player.choose(Outcome.BoostCreature, typeChoice, game)) {
                return false;
            }
            game.informPlayers(card.getName() + ": " + player.getLogName() + " has chosen " + typeChoice.getChoiceKey());
            chosenType = typeChoice.getChoiceKey();
            if (chosenType != null && !chosenType.isEmpty()) {
                BecomesCreatureTypeTargetEffect effect = new BecomesCreatureTypeTargetEffect(this.duration, SubType.byDescription(chosenType));
                effect.setTargetPointer(new FixedTarget(this.getTargetPointer().getFirst(game, source), game));
                game.addEffect(effect, source);
                return true;
            }
        }
        return false;
    }

    @Override
    public BecomesChosenCreatureTypeTargetEffect copy() {
        return new BecomesChosenCreatureTypeTargetEffect(this);
    }
}

