/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;

public class BecomesCreatureSourceEffect
extends ContinuousEffectImpl {
    private final Token token;
    private final CardType retainType;
    private boolean loseAbilities = false;
    private boolean loseEquipmentType = false;
    private boolean keepCreatureSubtypes;
    private DynamicValue power = null;
    private DynamicValue toughness = null;
    private boolean durationRuleAtStart;

    public BecomesCreatureSourceEffect(Token token, CardType retainType, Duration duration) {
        super(duration, Outcome.BecomeCreature);
        this.token = token;
        this.retainType = retainType;
        this.keepCreatureSubtypes = retainType == CardType.ENCHANTMENT;
        this.durationRuleAtStart = retainType == CardType.PLANESWALKER || retainType == CardType.CREATURE;
        this.setText();
        this.addDependencyType(DependencyType.BecomeCreature);
    }

    protected BecomesCreatureSourceEffect(BecomesCreatureSourceEffect effect) {
        super(effect);
        this.token = effect.token.copy();
        this.retainType = effect.retainType;
        this.loseAbilities = effect.loseAbilities;
        this.loseEquipmentType = effect.loseEquipmentType;
        this.keepCreatureSubtypes = effect.keepCreatureSubtypes;
        if (effect.power != null) {
            this.power = effect.power.copy();
        }
        if (effect.toughness != null) {
            this.toughness = effect.toughness.copy();
        }
        this.durationRuleAtStart = effect.durationRuleAtStart;
    }

    @Override
    public BecomesCreatureSourceEffect copy() {
        return new BecomesCreatureSourceEffect(this);
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        if (this.getAffectedObjectsSet()) {
            this.affectedObjectList.add(new MageObjectReference(source.getSourceId(), game));
        }
    }

    @Override
    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = this.getAffectedObjectsSet() ? ((MageObjectReference)this.affectedObjectList.get(0)).getPermanent(game) : game.getPermanent(source.getSourceId());
        if (permanent == null) {
            if (this.duration == Duration.Custom) {
                this.discard();
            }
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                if (this.retainType == null) {
                    permanent.removeAllCardTypes(game);
                    permanent.removeAllSubTypes(game);
                }
                for (SuperType superType : this.token.getSuperType(game)) {
                    permanent.addSuperType(game, superType);
                }
                for (CardType cardType : this.token.getCardType(game)) {
                    permanent.addCardType(game, cardType);
                }
                if (this.loseEquipmentType) {
                    permanent.removeSubType(game, SubType.EQUIPMENT);
                }
                if (!this.keepCreatureSubtypes) {
                    permanent.removeAllCreatureTypes(game);
                }
                permanent.copySubTypesFrom(game, this.token);
                break;
            }
            case ColorChangingEffects_5: {
                if (!this.token.getColor(game).hasColor()) break;
                permanent.getColor(game).setColor(this.token.getColor(game));
                break;
            }
            case AbilityAddingRemovingEffects_6: {
                if (this.loseAbilities) {
                    permanent.removeAllAbilities(source.getSourceId(), game);
                }
                for (Ability ability : this.token.getAbilities()) {
                    permanent.addAbility(ability, source.getSourceId(), game, true);
                }
                break;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                if (this.power != null) {
                    permanent.getPower().setModifiedBaseValue(this.power.calculate(game, source, this));
                } else if (this.token.getPower() != null) {
                    permanent.getPower().setModifiedBaseValue(this.token.getPower().getValue());
                }
                if (this.toughness != null) {
                    permanent.getToughness().setModifiedBaseValue(this.toughness.calculate(game, source, this));
                    break;
                }
                if (this.token.getToughness() == null) break;
                permanent.getToughness().setModifiedBaseValue(this.token.getToughness().getValue());
            }
        }
        return true;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return false;
    }

    public BecomesCreatureSourceEffect withDynamicPT(DynamicValue power, DynamicValue toughness) {
        this.power = power;
        this.toughness = toughness;
        return this;
    }

    public BecomesCreatureSourceEffect andLoseAbilities(boolean loseAbilities) {
        this.loseAbilities = loseAbilities;
        return this;
    }

    public BecomesCreatureSourceEffect andNotEquipment(boolean notEquipment) {
        this.loseEquipmentType = notEquipment;
        return this;
    }

    public BecomesCreatureSourceEffect withKeepCreatureSubtypes(boolean keepCreatureSubtypes) {
        this.keepCreatureSubtypes = keepCreatureSubtypes;
        this.setText();
        return this;
    }

    public BecomesCreatureSourceEffect withDurationRuleAtStart(boolean durationRuleAtStart) {
        this.durationRuleAtStart = durationRuleAtStart;
        this.setText();
        return this;
    }

    private void setText() {
        StringBuilder sb = new StringBuilder();
        if (!this.duration.toString().isEmpty() && this.durationRuleAtStart) {
            sb.append(this.duration.toString());
            sb.append(", ");
        }
        sb.append("{this} becomes a ");
        sb.append(this.token.getDescription());
        if (this.keepCreatureSubtypes) {
            sb.append(" in addition to its other types");
        }
        if (!this.duration.toString().isEmpty() && !this.durationRuleAtStart) {
            sb.append(" ");
            sb.append(this.duration.toString());
        }
        if (this.retainType == CardType.PLANESWALKER) {
            sb.append(" that's still a planeswalker");
        }
        if (this.retainType == CardType.LAND) {
            if (this.token.getDescription().endsWith(".\"")) {
                sb.append(" It's");
            } else {
                sb.append(". It's");
            }
            sb.append(" still a land");
        }
        this.staticText = sb.toString();
    }

    @Override
    public boolean hasLayer(Layer layer) {
        return layer == Layer.PTChangingEffects_7 || layer == Layer.AbilityAddingRemovingEffects_6 || layer == Layer.ColorChangingEffects_5 || layer == Layer.TypeChangingEffects_4;
    }
}

