/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.Mode;
import mage.abilities.TriggeredAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.ProtectionAbility;
import mage.abilities.mana.ManaAbility;
import mage.constants.AttachmentType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

public class GainAbilityAttachedEffect
extends ContinuousEffectImpl {
    protected Ability ability;
    protected AttachmentType attachmentType;
    protected boolean independentEffect;
    protected String targetObjectName;
    protected boolean doesntRemoveItself = false;
    protected boolean useQuotes = false;

    public GainAbilityAttachedEffect(Ability ability, AttachmentType attachmentType) {
        this(ability, attachmentType, Duration.WhileOnBattlefield);
    }

    public GainAbilityAttachedEffect(Ability ability, AttachmentType attachmentType, Duration duration) {
        this(ability, attachmentType, duration, null);
    }

    public GainAbilityAttachedEffect(Ability ability, AttachmentType attachmentType, Duration duration, String rule) {
        this(ability, attachmentType, duration, rule, "creature");
    }

    public GainAbilityAttachedEffect(Ability ability, AttachmentType attachmentType, Duration duration, String rule, String targetObjectName) {
        super(duration, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.targetObjectName = targetObjectName;
        this.ability = ability;
        this.attachmentType = attachmentType;
        switch (duration) {
            case WhileOnBattlefield: 
            case WhileInGraveyard: 
            case WhileOnStack: {
                this.independentEffect = false;
                break;
            }
            default: {
                this.independentEffect = true;
            }
        }
        if (rule != null) {
            this.staticText = rule;
        }
        this.generateGainAbilityDependencies(ability, null);
    }

    protected GainAbilityAttachedEffect(GainAbilityAttachedEffect effect) {
        super(effect);
        this.ability = effect.ability.copy();
        this.ability.newId();
        this.attachmentType = effect.attachmentType;
        this.independentEffect = effect.independentEffect;
        this.targetObjectName = effect.targetObjectName;
        this.doesntRemoveItself = effect.doesntRemoveItself;
        this.useQuotes = effect.useQuotes;
    }

    @Override
    public GainAbilityAttachedEffect copy() {
        return new GainAbilityAttachedEffect(this);
    }

    @Override
    public void init(Ability source, Game game) {
        Permanent equipment;
        if (this.getAffectedObjectsSetAtInit(source) && (equipment = game.getPermanentOrLKIBattlefield(source.getSourceId())) != null && equipment.getAttachedTo() != null) {
            this.setTargetPointer(new FixedTarget(equipment.getAttachedTo(), game.getState().getZoneChangeCounter(equipment.getAttachedTo())));
        }
        super.init(source, game);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        if (this.getAffectedObjectsSet()) {
            permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (permanent == null) {
                this.discard();
                return true;
            }
        } else {
            Permanent equipment = game.getPermanent(source.getSourceId());
            permanent = equipment != null && equipment.getAttachedTo() != null ? game.getPermanentOrLKIBattlefield(equipment.getAttachedTo()) : null;
        }
        if (permanent != null) {
            if (this.doesntRemoveItself && this.ability instanceof ProtectionAbility) {
                ((ProtectionAbility)this.ability).setAuraIdNotToBeRemoved(source.getSourceId());
            }
            permanent.addAbility(this.ability, source.getSourceId(), game);
            this.afterGain(game, source, permanent, this.ability);
        }
        return true;
    }

    public void afterGain(Game game, Ability source, Permanent permanent, Ability addedAbility) {
    }

    public GainAbilityAttachedEffect setDoesntRemoveItself(boolean doesntRemoveItself) {
        this.doesntRemoveItself = doesntRemoveItself;
        return this;
    }

    public GainAbilityAttachedEffect withQuotes(boolean useQuotes) {
        this.useQuotes = useQuotes;
        return this;
    }

    @Override
    public String getText(Mode mode) {
        boolean quotes;
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder();
        if (this.attachmentType != null) {
            sb.append(this.attachmentType.verb().toLowerCase());
            sb.append(" " + this.targetObjectName + " ");
        }
        if (this.duration == Duration.WhileOnBattlefield) {
            sb.append("has ");
        } else {
            sb.append("gains ");
        }
        boolean bl = quotes = this.useQuotes || this.ability instanceof SimpleActivatedAbility || this.ability instanceof TriggeredAbility || this.ability instanceof LoyaltyAbility || this.ability instanceof ManaAbility || this.ability.getRule().startsWith("If ");
        if (quotes) {
            sb.append('\"');
        }
        sb.append(CardUtil.stripReminderText(this.ability.getRule("this " + this.targetObjectName)));
        if (quotes) {
            sb.append('\"');
        }
        if (!this.duration.toString().isEmpty()) {
            sb.append(' ').append((Object)this.duration);
        }
        if (this.doesntRemoveItself) {
            sb.append(". This effect doesn't remove {this}.");
        }
        return sb.toString();
    }
}

