/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.CommanderCardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.common.FilterNonlandCard;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.util.CardUtil;

public class GainAbilityControlledSpellsEffect
extends ContinuousEffectImpl {
    private final Ability ability;
    private final FilterNonlandCard filter;

    public GainAbilityControlledSpellsEffect(Ability ability, FilterNonlandCard filter) {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.ability = ability;
        this.filter = filter;
        this.staticText = filter.getMessage() + " have " + CardUtil.getTextWithFirstCharLowerCase(CardUtil.stripReminderText(ability.getRule()));
    }

    private GainAbilityControlledSpellsEffect(GainAbilityControlledSpellsEffect effect) {
        super(effect);
        this.ability = effect.ability;
        this.filter = effect.filter;
    }

    @Override
    public GainAbilityControlledSpellsEffect copy() {
        return new GainAbilityControlledSpellsEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        for (Card card2 : game.getExile().getCardsInRange(game, source.getControllerId())) {
            if (!this.filter.match(card2, player.getId(), source, game)) continue;
            game.getState().addOtherAbility(card2, this.ability);
        }
        for (Card card2 : player.getLibrary().getCards(game)) {
            if (!this.filter.match(card2, player.getId(), source, game)) continue;
            game.getState().addOtherAbility(card2, this.ability);
        }
        for (Card card2 : player.getHand().getCards(game)) {
            if (!this.filter.match(card2, player.getId(), source, game)) continue;
            game.getState().addOtherAbility(card2, this.ability);
        }
        for (Card card2 : player.getGraveyard().getCards(game)) {
            if (!this.filter.match(card2, player.getId(), source, game)) continue;
            game.getState().addOtherAbility(card2, this.ability);
        }
        game.getCommanderCardsFromCommandZone(player, CommanderCardType.ANY).stream().filter(card -> this.filter.match((Card)card, player.getId(), source, game)).forEach(card -> game.getState().addOtherAbility((Card)card, this.ability));
        for (StackObject stackObject : game.getStack()) {
            Card card3;
            if (!(stackObject instanceof Spell) || !stackObject.isControlledBy(source.getControllerId()) || (card3 = game.getCard(stackObject.getSourceId())) == null || !this.filter.match((Spell)stackObject, player.getId(), source, game)) continue;
            game.getState().addOtherAbility(card3, this.ability);
        }
        return true;
    }
}

