/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.players.Player;

public class GainAbilityControllerEffect
extends ContinuousEffectImpl {
    protected Ability ability;

    public GainAbilityControllerEffect(Ability ability) {
        this(ability, Duration.WhileOnBattlefield);
    }

    public GainAbilityControllerEffect(Ability ability, Duration duration) {
        super(duration, Layer.PlayerEffects, SubLayer.NA, Outcome.AddAbility);
        this.ability = ability;
        this.staticText = "you " + (duration == Duration.WhileOnBattlefield ? "have" : "gain") + ' ' + ability.getRule();
        if (!duration.toString().isEmpty()) {
            this.staticText = this.staticText + ' ' + duration.toString();
        }
    }

    protected GainAbilityControllerEffect(GainAbilityControllerEffect effect) {
        super(effect);
        this.ability = effect.ability.copy();
    }

    @Override
    public GainAbilityControllerEffect copy() {
        return new GainAbilityControllerEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            player.addAbility(this.ability);
            if (this.duration == Duration.Custom && game.getPermanent(source.getSourceId()) == null) {
                this.discard();
            }
            return true;
        }
        this.discard();
        return false;
    }
}

