/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class LoseAbilityTargetEffect
extends ContinuousEffectImpl {
    private final Ability ability;

    public LoseAbilityTargetEffect(Ability ability, Duration duration) {
        super(duration, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.LoseAbility);
        this.ability = ability;
    }

    protected LoseAbilityTargetEffect(LoseAbilityTargetEffect effect) {
        super(effect);
        this.ability = effect.ability.copy();
    }

    @Override
    public LoseAbilityTargetEffect copy() {
        return new LoseAbilityTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        boolean result = false;
        for (UUID uuid : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(uuid);
            if (permanent == null) continue;
            permanent.removeAbility(this.ability, source.getSourceId(), game);
            result = true;
        }
        return result;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return this.getTargetPointer().describeTargets(mode.getTargets(), "it") + " loses " + CardUtil.stripReminderText(this.ability.getRule()) + (this.duration.toString().isEmpty() ? "" : ' ' + this.duration.toString());
    }
}

