/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class LoseCreatureTypeSourceEffect
extends ContinuousEffectImpl {
    private final DynamicValue dynamicValue;
    private final int lessThan;

    public LoseCreatureTypeSourceEffect(DynamicValue dynamicValue, int lessThan) {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Detriment);
        this.dynamicValue = dynamicValue;
        this.lessThan = lessThan;
        this.setText();
    }

    protected LoseCreatureTypeSourceEffect(LoseCreatureTypeSourceEffect effect) {
        super(effect);
        this.dynamicValue = effect.dynamicValue;
        this.lessThan = effect.lessThan;
    }

    @Override
    public LoseCreatureTypeSourceEffect copy() {
        return new LoseCreatureTypeSourceEffect(this);
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        if (this.duration.isOnlyValidIfNoZoneChange() && source.getSourcePermanentIfItStillExists(game) == null) {
            this.discard();
        }
    }

    @Override
    public boolean apply(Game game, Ability source) {
        if (this.dynamicValue.calculate(game, source, this) >= this.lessThan) {
            return false;
        }
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        permanent.removeCardType(game, CardType.CREATURE);
        if (!permanent.isKindred(game)) {
            permanent.removeAllCreatureTypes(game);
        }
        if (permanent.isAttacking() || permanent.getBlocking() > 0) {
            permanent.removeFromCombat(game);
        }
        return true;
    }

    private void setText() {
        StringBuilder sb = new StringBuilder("As long as ");
        sb.append(this.dynamicValue.getMessage()).append(" is less than ");
        sb.append(CardUtil.numberToText(this.lessThan)).append(", {this} isn't a creature");
        this.staticText = sb.toString();
    }
}

