/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class PlayAdditionalLandsControllerEffect
extends ContinuousEffectImpl {
    protected int additionalCards;

    public PlayAdditionalLandsControllerEffect(int additionalCards, Duration duration) {
        super(duration, Layer.PlayerEffects, SubLayer.NA, Outcome.Benefit);
        this.additionalCards = additionalCards;
        this.setText();
    }

    protected PlayAdditionalLandsControllerEffect(PlayAdditionalLandsControllerEffect effect) {
        super(effect);
        this.additionalCards = effect.additionalCards;
    }

    @Override
    public PlayAdditionalLandsControllerEffect copy() {
        return new PlayAdditionalLandsControllerEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.setLandsPerTurn(CardUtil.overflowInc(player.getLandsPerTurn(), this.additionalCards));
        return true;
    }

    private void setText() {
        StringBuilder sb = new StringBuilder();
        sb.append("You may play ");
        if (this.additionalCards == Integer.MAX_VALUE) {
            sb.append("any number of");
        } else {
            if (this.additionalCards > 1 && this.duration == Duration.EndOfTurn) {
                sb.append("up to ");
            }
            sb.append(CardUtil.numberToText(this.additionalCards, "an"));
        }
        sb.append(" additional land").append(this.additionalCards == 1 ? "" : "s").append(this.duration == Duration.EndOfTurn ? " this turn" : " on each of your turns");
        this.staticText = sb.toString();
    }
}

