/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.AttachmentType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class SetBasePowerToughnessAttachedEffect
extends ContinuousEffectImpl {
    private final int power;
    private final int toughness;

    public SetBasePowerToughnessAttachedEffect(int power, int toughness, AttachmentType attachmentType) {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.SetPT_7b, Outcome.BoostCreature);
        this.staticText = attachmentType.verb() + " creature has base power and toughness " + power + "/" + toughness;
        this.power = power;
        this.toughness = toughness;
    }

    protected SetBasePowerToughnessAttachedEffect(SetBasePowerToughnessAttachedEffect effect) {
        super(effect);
        this.power = effect.power;
        this.toughness = effect.toughness;
    }

    @Override
    public SetBasePowerToughnessAttachedEffect copy() {
        return new SetBasePowerToughnessAttachedEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment == null || enchantment.getAttachedTo() == null) {
            return false;
        }
        Permanent enchanted = game.getPermanent(enchantment.getAttachedTo());
        if (enchanted == null) {
            return false;
        }
        enchanted.getPower().setModifiedBaseValue(this.power);
        enchanted.getToughness().setModifiedBaseValue(this.toughness);
        return true;
    }
}

