/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class SetBasePowerToughnessTargetEffect
extends ContinuousEffectImpl {
    private final DynamicValue power;
    private final DynamicValue toughness;

    public SetBasePowerToughnessTargetEffect(DynamicValue power, DynamicValue toughness, Duration duration) {
        super(duration, Layer.PTChangingEffects_7, SubLayer.SetPT_7b, Outcome.BoostCreature);
        this.power = power;
        this.toughness = toughness;
    }

    public SetBasePowerToughnessTargetEffect(int power, int toughness, Duration duration) {
        this(StaticValue.get(power), StaticValue.get(toughness), duration);
    }

    protected SetBasePowerToughnessTargetEffect(SetBasePowerToughnessTargetEffect effect) {
        super(effect);
        this.power = effect.power;
        this.toughness = effect.toughness;
    }

    @Override
    public SetBasePowerToughnessTargetEffect copy() {
        return new SetBasePowerToughnessTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        boolean result = false;
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Permanent target = game.getPermanent(targetId);
            if (target == null) continue;
            if (this.power != null) {
                target.getPower().setModifiedBaseValue(this.power.calculate(game, source, this));
            }
            if (this.toughness != null) {
                target.getToughness().setModifiedBaseValue(this.toughness.calculate(game, source, this));
            }
            result = true;
        }
        return result;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return this.getTargetPointer().describeTargets(mode.getTargets(), "that creature") + (this.getTargetPointer().isPlural(mode.getTargets()) ? " have" : " has") + " base power and toughness " + this.power + '/' + this.toughness + (this.duration.toString().isEmpty() ? "" : ' ' + this.duration.toString());
    }
}

