/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.AttachmentType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class SetCardSubtypeAttachedEffect
extends ContinuousEffectImpl {
    private List<SubType> setSubtypes = new ArrayList<SubType>();
    private final AttachmentType attachmentType;

    public SetCardSubtypeAttachedEffect(Duration duration, AttachmentType attachmentType, SubType ... setSubtype) {
        super(duration, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        this.setSubtypes.addAll(Arrays.asList(setSubtype));
        this.attachmentType = attachmentType;
        this.setText();
    }

    protected SetCardSubtypeAttachedEffect(SetCardSubtypeAttachedEffect effect) {
        super(effect);
        this.setSubtypes = effect.setSubtypes;
        this.attachmentType = effect.attachmentType;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent equipment = game.getPermanent(source.getSourceId());
        if (equipment == null || equipment.getAttachedTo() == null) {
            return true;
        }
        Permanent target = game.getPermanent(equipment.getAttachedTo());
        if (target == null) {
            return true;
        }
        target.removeAllCreatureTypes(game);
        target.addSubType(game, this.setSubtypes);
        return true;
    }

    @Override
    public SetCardSubtypeAttachedEffect copy() {
        return new SetCardSubtypeAttachedEffect(this);
    }

    private void setText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.attachmentType.verb());
        sb.append(" creature is a");
        for (SubType subtype : this.setSubtypes) {
            sb.append(' ').append((Object)subtype);
        }
        this.staticText = sb.toString();
    }
}

