/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.cost;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class CastFromHandForFreeEffect
extends OneShotEffect {
    private final FilterCard filter;

    public CastFromHandForFreeEffect(FilterCard filter) {
        super(Outcome.PlayForFree);
        this.filter = filter;
        this.staticText = "you may cast " + filter.getMessage() + (filter.getMessage().contains("your hand") ? "" : " from your hand") + " without paying its mana cost";
    }

    protected CastFromHandForFreeEffect(CastFromHandForFreeEffect effect) {
        super(effect);
        this.filter = effect.filter;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        return controller != null && CardUtil.castSpellWithAttributesForFree(controller, source, game, new CardsImpl(controller.getHand()), this.filter);
    }

    @Override
    public CastFromHandForFreeEffect copy() {
        return new CastFromHandForFreeEffect(this);
    }
}

