/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.counter;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class AddPlusOneCountersAttachedEffect
extends OneShotEffect {
    private int amount;

    public AddPlusOneCountersAttachedEffect(int amount) {
        super(Outcome.BoostCreature);
        this.amount = amount;
        this.setText();
    }

    protected AddPlusOneCountersAttachedEffect(AddPlusOneCountersAttachedEffect effect) {
        super(effect);
        this.amount = effect.amount;
    }

    @Override
    public AddPlusOneCountersAttachedEffect copy() {
        return new AddPlusOneCountersAttachedEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent creature;
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment == null) {
            enchantment = (Permanent)game.getLastKnownInformation(source.getSourceId(), Zone.BATTLEFIELD);
        }
        if (enchantment != null && enchantment.getAttachedTo() != null && (creature = game.getPermanent(enchantment.getAttachedTo())) != null) {
            creature.addCounters(CounterType.P1P1.createInstance(this.amount), source.getControllerId(), source, game);
        }
        return true;
    }

    private void setText() {
        this.staticText = this.amount > 1 ? "put " + CardUtil.numberToText(this.amount) + " +1/+1 counters on enchanted creature" : "put a +1/+1 counter on enchanted creature";
    }
}

