/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.counter;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class RemoveCounterSourceEffect
extends OneShotEffect {
    private final Counter counter;

    public RemoveCounterSourceEffect(Counter counter) {
        super(Outcome.UnboostCreature);
        this.counter = counter;
        this.staticText = "remove " + counter.getDescription() + " from {this}";
    }

    public RemoveCounterSourceEffect(RemoveCounterSourceEffect effect) {
        super(effect);
        this.counter = effect.counter.copy();
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent != null) {
            int toRemove = Math.min(this.counter.getCount(), permanent.getCounters(game).getCount(this.counter.getName()));
            if (toRemove > 0) {
                permanent.removeCounters(this.counter.getName(), toRemove, source, game);
                game.informPlayers("Removed " + toRemove + ' ' + this.counter.getName() + " counter from " + permanent.getLogName());
            }
            return true;
        }
        Card card = source.getSourceCardIfItStillExists(game);
        if (card != null) {
            int toRemove = Math.min(this.counter.getCount(), card.getCounters(game).getCount(this.counter.getName()));
            if (toRemove > 0) {
                card.removeCounters(this.counter.getName(), toRemove, source, game);
                game.informPlayers("Removed " + toRemove + ' ' + this.counter.getName() + " counter from " + card.getLogName() + " (" + card.getCounters(game).getCount(this.counter.getName()) + " left)");
            }
            return true;
        }
        return false;
    }

    @Override
    public RemoveCounterSourceEffect copy() {
        return new RemoveCounterSourceEffect(this);
    }
}

