/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.counter;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;

class RemoveCountersAtEndOfTurn
extends OneShotEffect {
    private final CounterType counterType;

    RemoveCountersAtEndOfTurn(CounterType counterType) {
        super(Outcome.Detriment);
        this.counterType = counterType;
        String name = counterType.getName();
        this.staticText = "For each " + name + " counter you put on a creature this way, remove a " + name + " counter from that creature at the beginning of the next cleanup step.";
    }

    protected RemoveCountersAtEndOfTurn(RemoveCountersAtEndOfTurn effect) {
        super(effect);
        this.counterType = effect.counterType;
    }

    @Override
    public RemoveCountersAtEndOfTurn copy() {
        return new RemoveCountersAtEndOfTurn(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        if (!source.getTargets().isEmpty()) {
            Target multiTarget = (Target)source.getTargets().get(0);
            for (UUID target : multiTarget.getTargets()) {
                Permanent permanent = game.getPermanent(target);
                if (permanent == null) continue;
                permanent.removeCounters(this.counterType.getName(), multiTarget.getTargetAmount(target), source, game);
            }
            return true;
        }
        return false;
    }
}

