/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.discard;

import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetDiscard;
import mage.util.CardUtil;

public class DiscardEachPlayerEffect
extends OneShotEffect {
    protected DynamicValue amount;
    protected boolean randomDiscard;
    private TargetController targetController;

    public DiscardEachPlayerEffect() {
        this(StaticValue.get(1), false);
    }

    public DiscardEachPlayerEffect(TargetController targetController) {
        this(StaticValue.get(1), false, targetController);
    }

    public DiscardEachPlayerEffect(int amount, boolean randomDiscard) {
        this(StaticValue.get(amount), randomDiscard);
    }

    public DiscardEachPlayerEffect(DynamicValue amount, boolean randomDiscard) {
        this(amount, randomDiscard, TargetController.ANY);
    }

    public DiscardEachPlayerEffect(DynamicValue amount, boolean randomDiscard, TargetController targetController) {
        super(Outcome.Discard);
        this.randomDiscard = randomDiscard;
        this.amount = amount;
        this.targetController = targetController;
    }

    protected DiscardEachPlayerEffect(DiscardEachPlayerEffect effect) {
        super(effect);
        this.randomDiscard = effect.randomDiscard;
        this.amount = effect.amount;
        this.targetController = effect.targetController;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player;
        Player controller = game.getPlayer(source.getControllerId());
        HashMap<UUID, CardsImpl> cardsToDiscard = new HashMap<UUID, CardsImpl>();
        if (controller == null) {
            return true;
        }
        int toDiscard = this.amount.calculate(game, source, this);
        block4: for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            switch (this.targetController) {
                case NOT_YOU: {
                    if (!playerId.equals(source.getControllerId())) break;
                    continue block4;
                }
                case OPPONENT: {
                    if (game.getOpponents(source.getControllerId()).contains(playerId)) break;
                    continue block4;
                }
            }
            if (this.randomDiscard) {
                player.discard(toDiscard, true, false, source, game);
                continue;
            }
            int numberOfCardsToDiscard = Math.min(toDiscard, player.getHand().size());
            CardsImpl cards = new CardsImpl();
            if (numberOfCardsToDiscard > 0) {
                TargetDiscard target = new TargetDiscard(numberOfCardsToDiscard, numberOfCardsToDiscard, StaticFilters.FILTER_CARD, playerId);
                player.chooseTarget(this.outcome, target, source, game);
                cards.addAll(target.getTargets());
            }
            cardsToDiscard.put(playerId, cards);
        }
        if (this.randomDiscard) {
            return true;
        }
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            player.discard((Cards)cardsToDiscard.get(playerId), false, source, game);
        }
        return true;
    }

    @Override
    public DiscardEachPlayerEffect copy() {
        return new DiscardEachPlayerEffect(this);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("each ");
        switch (this.targetController) {
            case NOT_YOU: {
                sb.append("other player");
                break;
            }
            case OPPONENT: {
                sb.append("opponent");
                break;
            }
            case ANY: {
                sb.append("player");
            }
        }
        sb.append(" discards ");
        sb.append(CardUtil.numberToText(this.amount.toString(), "a")).append(" card");
        try {
            if (Integer.parseInt(this.amount.toString()) > 1) {
                sb.append('s');
            }
        }
        catch (Exception e) {
            sb.append('s');
        }
        if (this.randomDiscard) {
            sb.append(" at random");
        }
        return sb.toString();
    }
}

