/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.ruleModifying;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterLandCard;
import mage.game.Game;
import mage.players.Player;

public class PlayFromGraveyardControllerEffect
extends AsThoughEffectImpl {
    private static final FilterCard filterPlayCards = new FilterCard("cards");
    private static final FilterCard filterPlayLands = new FilterLandCard("lands");
    private static final FilterCard filterPlayCast = new FilterCard("play lands and cast spells");
    private final FilterCard filter;

    public static PlayFromGraveyardControllerEffect playCards() {
        return new PlayFromGraveyardControllerEffect(filterPlayCards);
    }

    public static PlayFromGraveyardControllerEffect playLands() {
        return new PlayFromGraveyardControllerEffect(filterPlayLands);
    }

    public static PlayFromGraveyardControllerEffect playLandsAndCastSpells(Duration duration) {
        return new PlayFromGraveyardControllerEffect(filterPlayCast, duration);
    }

    public PlayFromGraveyardControllerEffect(FilterCard filter) {
        this(filter, Duration.WhileOnBattlefield);
    }

    public PlayFromGraveyardControllerEffect(FilterCard filter, Duration duration) {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, duration, Outcome.Benefit);
        String durationString;
        this.filter = filter;
        String filterMessage = filter.getMessage();
        if (!filterMessage.startsWith("play ") && !filterMessage.startsWith("cast")) {
            filterMessage = filterMessage.contains("cards") || filterMessage.contains("lands") ? "play " + filterMessage : "cast " + filterMessage;
        }
        if (!(durationString = duration.toString()).isEmpty()) {
            durationString = durationString + ", ";
        }
        this.staticText = durationString + "you may " + filterMessage + " from your graveyard";
    }

    protected PlayFromGraveyardControllerEffect(PlayFromGraveyardControllerEffect effect) {
        super(effect);
        this.filter = effect.filter;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return true;
    }

    @Override
    public PlayFromGraveyardControllerEffect copy() {
        return new PlayFromGraveyardControllerEffect(this);
    }

    @Override
    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        throw new IllegalArgumentException("Wrong code usage: can't call applies method on empty affectedAbility");
    }

    @Override
    public boolean applies(UUID objectId, Ability affectedAbility, Ability source, Game game, UUID playerId) {
        Card cardToCheck = game.getCard(objectId);
        if (cardToCheck == null) {
            return false;
        }
        if (!playerId.equals(source.getControllerId())) {
            return false;
        }
        Player player = game.getPlayer(cardToCheck.getOwnerId());
        if (player == null || !player.getId().equals(playerId)) {
            return false;
        }
        UUID needCardId = cardToCheck.getMainCard().getId();
        if (player.getGraveyard().getCards(game).stream().noneMatch(c -> c.getId().equals(needCardId))) {
            return false;
        }
        if (!cardToCheck.isLand(game) && cardToCheck.getManaCost().isEmpty()) {
            return false;
        }
        if (affectedAbility instanceof SpellAbility) {
            cardToCheck = ((SpellAbility)affectedAbility).getCharacteristics(game);
        }
        return this.filter.match(cardToCheck, playerId, source, game);
    }
}

