/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.ruleModifying;

import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.target.Target;

public class TargetsHaveToTargetPermanentIfAbleEffect
extends ContinuousRuleModifyingEffectImpl {
    private final FilterPermanent filter;
    private static final FilterPermanent flagbearerFilter = new FilterPermanent(SubType.FLAGBEARER, "one Flagbearer");

    public TargetsHaveToTargetPermanentIfAbleEffect() {
        this(flagbearerFilter);
    }

    public TargetsHaveToTargetPermanentIfAbleEffect(FilterPermanent filter) {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.filter = filter;
        this.staticText = "While an opponent is choosing targets as part of casting a spell they control or activating an ability they control, that player must choose at least " + this.filter.getMessage() + " on the battlefield if able";
    }

    private TargetsHaveToTargetPermanentIfAbleEffect(TargetsHaveToTargetPermanentIfAbleEffect effect) {
        super(effect);
        this.filter = effect.filter;
    }

    @Override
    public TargetsHaveToTargetPermanentIfAbleEffect copy() {
        return new TargetsHaveToTargetPermanentIfAbleEffect(this);
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TARGETS_VALID;
    }

    @Override
    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You must choose at least " + this.filter.getMessage() + " on the battlefield as target if able (" + mageObject.getIdName() + ").";
        }
        return null;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetingPlayer = game.getPlayer(event.getPlayerId());
        if (controller != null && targetingPlayer.isHuman() && controller.hasOpponent(event.getPlayerId(), game)) {
            StackObject stackObject = game.getStack().getStackObject(event.getSourceId());
            if (stackObject.isCopy()) {
                return false;
            }
            Ability stackAbility = stackObject.getStackAbility();
            if (!stackAbility.isActivatedAbility() && !(stackAbility instanceof SpellAbility)) {
                return false;
            }
            if (!stackAbility.isControlledBy(targetingPlayer.getId())) {
                return false;
            }
            Ability targetAbility = (Ability)this.getValue("targetAbility");
            if (targetAbility != null) {
                Ability ability = targetAbility.copy();
                List<Permanent> allowedPermanents = game.getBattlefield().getActivePermanents(this.filter, event.getPlayerId(), source, game);
                if (!allowedPermanents.isEmpty()) {
                    boolean canTargetAllowedPermanent = false;
                    for (UUID modeId : ability.getModes().getSelectedModes()) {
                        ability.getModes().setActiveMode(modeId);
                        for (Target target : ability.getTargets()) {
                            for (Permanent allowedPermanent : allowedPermanents) {
                                if (target.getTargets().contains(allowedPermanent.getId())) {
                                    return false;
                                }
                                if (!target.canTarget(stackObject.getControllerId(), allowedPermanent.getId(), source, game)) continue;
                                canTargetAllowedPermanent = true;
                            }
                        }
                    }
                    return canTargetAllowedPermanent;
                }
            }
        }
        return false;
    }
}

