/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.search;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.SearchEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

public class SearchLibraryPutInHandEffect
extends SearchEffect {
    private final boolean reveal;
    private final boolean textThatCard;

    public SearchLibraryPutInHandEffect(TargetCardInLibrary target, boolean reveal) {
        this(target, reveal, false);
    }

    public SearchLibraryPutInHandEffect(TargetCardInLibrary target, boolean reveal, boolean textThatCard) {
        super(target, Outcome.DrawCard);
        this.reveal = reveal;
        this.textThatCard = textThatCard;
        this.setText();
    }

    protected SearchLibraryPutInHandEffect(SearchLibraryPutInHandEffect effect) {
        super(effect);
        this.reveal = effect.reveal;
        this.textThatCard = effect.textThatCard;
    }

    @Override
    public SearchLibraryPutInHandEffect copy() {
        return new SearchLibraryPutInHandEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        this.target.clearChosen();
        if (controller.searchLibrary(this.target, source, game)) {
            if (!this.target.getTargets().isEmpty()) {
                CardsImpl cards = new CardsImpl();
                for (UUID cardId : this.target.getTargets()) {
                    Card card = game.getCard(cardId);
                    if (card == null) continue;
                    cards.add(card);
                }
                controller.moveCards(cards, Zone.HAND, source, game);
                if (this.reveal) {
                    String name = "Reveal";
                    Card sourceCard = game.getCard(source.getSourceId());
                    if (sourceCard != null) {
                        name = sourceCard.getIdName();
                    }
                    controller.revealCards(name, (Cards)cards, game);
                }
            }
            controller.shuffleLibrary(source, game);
            return true;
        }
        controller.shuffleLibrary(source, game);
        return false;
    }

    private void setText() {
        StringBuilder sb = new StringBuilder();
        sb.append("search your library for ");
        sb.append(this.target.getDescription());
        if (this.target.getMaxNumberOfTargets() > 1) {
            if (this.reveal) {
                sb.append(", reveal ");
                sb.append(this.textThatCard ? "those cards" : "them");
                sb.append(", put them");
            } else {
                sb.append(", put ");
                sb.append(this.textThatCard ? "those cards" : "them");
            }
        } else if (this.reveal) {
            sb.append(", reveal ");
            sb.append(this.textThatCard ? "that card" : "it");
            sb.append(", put it");
        } else {
            sb.append(", put ");
            sb.append(this.textThatCard ? "that card" : "it");
        }
        sb.append(" into your hand, then shuffle");
        this.staticText = sb.toString();
    }
}

