/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.search;

import java.util.Collection;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.SearchEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

public class SearchLibraryPutOnLibraryEffect
extends SearchEffect {
    private boolean reveal;

    public SearchLibraryPutOnLibraryEffect(TargetCardInLibrary target, boolean reveal) {
        super(target, Outcome.DrawCard);
        this.reveal = reveal;
        this.setText();
    }

    protected SearchLibraryPutOnLibraryEffect(SearchLibraryPutOnLibraryEffect effect) {
        super(effect);
        this.reveal = effect.reveal;
    }

    @Override
    public SearchLibraryPutOnLibraryEffect copy() {
        return new SearchLibraryPutOnLibraryEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        if (controller.searchLibrary(this.target, source, game)) {
            CardsImpl foundCards = new CardsImpl((Collection<UUID>)this.target.getTargets());
            if (this.reveal && !foundCards.isEmpty()) {
                controller.revealCards(sourceObject.getIdName(), (Cards)foundCards, game);
            }
            controller.shuffleLibrary(source, game);
            controller.putCardsOnTopOfLibrary(foundCards, game, source, this.reveal);
            return true;
        }
        controller.shuffleLibrary(source, game);
        return false;
    }

    private void setText() {
        StringBuilder sb = new StringBuilder();
        sb.append("search your library for ").append(CardUtil.addArticle(this.target.getTargetName()));
        if (this.reveal) {
            sb.append(", reveal it");
        }
        sb.append(", then shuffle and put that card on top");
        this.staticText = sb.toString();
    }
}

