/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.search;

import java.util.Collection;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.SearchEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

public class SearchLibraryPutOntoBattlefieldTappedRestInHandEffect
extends SearchEffect {
    private final FilterCard filter;
    private final int numToBattlefield;

    public SearchLibraryPutOntoBattlefieldTappedRestInHandEffect(TargetCardInLibrary target, int numToBattlefield) {
        super(target, Outcome.PutLandInPlay);
        this.staticText = "search your library for " + target.getDescription() + ", reveal those cards, put " + CardUtil.numberToText(numToBattlefield) + " onto the battlefield tapped and the other into your hand, then shuffle";
        this.filter = new FilterCard((numToBattlefield > 1 ? "cards" : "card") + " to put on the battlefield tapped");
        this.numToBattlefield = numToBattlefield;
    }

    public SearchLibraryPutOntoBattlefieldTappedRestInHandEffect(TargetCardInLibrary target) {
        this(target, 1);
    }

    protected SearchLibraryPutOntoBattlefieldTappedRestInHandEffect(SearchLibraryPutOntoBattlefieldTappedRestInHandEffect effect) {
        super(effect);
        this.filter = effect.filter.copy();
        this.numToBattlefield = effect.numToBattlefield;
    }

    @Override
    public SearchLibraryPutOntoBattlefieldTappedRestInHandEffect copy() {
        return new SearchLibraryPutOntoBattlefieldTappedRestInHandEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller == null || sourceObject == null) {
            return false;
        }
        if (controller.searchLibrary(this.target, source, game)) {
            if (!this.target.getTargets().isEmpty()) {
                CardsImpl cards;
                Card cardToBattlefield;
                CardsImpl revealed = new CardsImpl((Collection<UUID>)this.target.getTargets());
                controller.revealCards(sourceObject.getIdName(), (Cards)revealed, game);
                if (this.target.getTargets().size() >= 2) {
                    int maxToBattlefield = Math.min(this.numToBattlefield, this.target.getTargets().size());
                    TargetCardInLibrary targetCardsToBattlefield = new TargetCardInLibrary(maxToBattlefield, this.filter);
                    controller.choose(Outcome.PutLandInPlay, revealed, targetCardsToBattlefield, source, game);
                    CardsImpl cardsToBattlefield = new CardsImpl((Collection<UUID>)targetCardsToBattlefield.getTargets());
                    CardsImpl cardsToHand = new CardsImpl((Collection<UUID>)revealed);
                    if (!cardsToBattlefield.isEmpty()) {
                        controller.moveCards(cardsToBattlefield.getCards(game), Zone.BATTLEFIELD, source, game, true, false, false, null);
                        cardsToHand.removeAll(cardsToBattlefield);
                    }
                    controller.moveCardsToHandWithInfo(cardsToHand, source, game, true);
                } else if (this.target.getTargets().size() == 1 && (cardToBattlefield = (cards = new CardsImpl((Collection<UUID>)revealed)).getRandom(game)) != null) {
                    controller.moveCards(cardToBattlefield, Zone.BATTLEFIELD, source, game, true, false, false, null);
                }
            }
            controller.shuffleLibrary(source, game);
            return true;
        }
        controller.shuffleLibrary(source, game);
        return false;
    }
}

