/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.search;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

public abstract class SearchTargetGraveyardHandLibraryForCardNameAndExileEffect
extends OneShotEffect {
    protected String searchWhatText;
    protected String searchForText;
    protected boolean graveyardExileOptional;
    protected boolean drawForEachHandCard;
    protected int maxAmount;

    protected SearchTargetGraveyardHandLibraryForCardNameAndExileEffect(boolean graveyardExileOptional, String searchWhatText, String searchForText) {
        this(graveyardExileOptional, searchWhatText, searchForText, false);
    }

    protected SearchTargetGraveyardHandLibraryForCardNameAndExileEffect(boolean graveyardExileOptional, String searchWhatText, String searchForText, boolean drawForEachHandCard) {
        this(graveyardExileOptional, searchWhatText, searchForText, drawForEachHandCard, Integer.MAX_VALUE);
    }

    protected SearchTargetGraveyardHandLibraryForCardNameAndExileEffect(boolean graveyardExileOptional, String searchWhatText, String searchForText, boolean drawForEachHandCard, int maxAmount) {
        super(Outcome.Exile);
        this.searchWhatText = searchWhatText;
        this.searchForText = searchForText;
        this.graveyardExileOptional = graveyardExileOptional;
        this.drawForEachHandCard = drawForEachHandCard;
        this.maxAmount = maxAmount;
        this.staticText = "search " + searchWhatText + " graveyard, hand, and library for " + searchForText + " and exile them. " + (drawForEachHandCard ? "That player shuffles, then draws a card for each card exiled from their hand this way" : "Then that player shuffles");
    }

    protected SearchTargetGraveyardHandLibraryForCardNameAndExileEffect(SearchTargetGraveyardHandLibraryForCardNameAndExileEffect effect) {
        super(effect);
        this.searchWhatText = effect.searchWhatText;
        this.searchForText = effect.searchForText;
        this.graveyardExileOptional = effect.graveyardExileOptional;
        this.drawForEachHandCard = effect.drawForEachHandCard;
        this.maxAmount = effect.maxAmount;
    }

    protected boolean applySearchAndExile(Game game, Ability source, String cardName, UUID targetPlayerId) {
        Player controller = game.getPlayer(source.getControllerId());
        if (cardName != null && controller != null) {
            Player targetPlayer = game.getPlayer(targetPlayerId);
            if (targetPlayer != null) {
                TargetCard target;
                int handCards = 0;
                int maxRemaining = this.maxAmount;
                FilterCard filter = new FilterCard("card named \"" + cardName + "\"");
                filter.add(new NamePredicate(cardName));
                int cardsCount = Math.min(targetPlayer.getGraveyard().count(filter, game), maxRemaining);
                if (cardsCount > 0) {
                    filter.setMessage("card named " + cardName + " in the graveyard of " + targetPlayer.getName());
                    target = new TargetCard(this.graveyardExileOptional ? 0 : cardsCount, cardsCount, Zone.GRAVEYARD, filter);
                    target.withNotTarget(true);
                    if (controller.choose(Outcome.Exile, targetPlayer.getGraveyard(), target, source, game)) {
                        maxRemaining -= target.getTargets().size();
                        controller.moveCards(new CardsImpl((Collection<UUID>)target.getTargets()), Zone.EXILED, source, game);
                    }
                }
                cardsCount = Math.min(targetPlayer.getHand().count(filter, game), maxRemaining);
                filter.setMessage("card named " + cardName + " in the hand of " + targetPlayer.getName());
                target = new TargetCard(0, cardsCount, Zone.HAND, filter);
                target.withNotTarget(true);
                if (controller.choose(Outcome.Exile, targetPlayer.getHand(), target, source, game)) {
                    maxRemaining -= target.getTargets().size();
                    if (this.drawForEachHandCard) {
                        handCards = target.getTargets().size();
                    }
                    controller.moveCards(new CardsImpl((Collection<UUID>)target.getTargets()), Zone.EXILED, source, game);
                }
                CardsImpl cardsInLibrary = new CardsImpl();
                cardsInLibrary.addAllCards(targetPlayer.getLibrary().getCards(game));
                cardsCount = Math.min(cardsInLibrary.count(filter, game), maxRemaining);
                filter.setMessage("card named " + cardName + " in the library of " + targetPlayer.getLogName());
                TargetCardInLibrary targetLib = new TargetCardInLibrary(0, cardsCount, filter);
                if (controller.choose(Outcome.Exile, cardsInLibrary, targetLib, source, game)) {
                    controller.moveCards(new CardsImpl((Collection<UUID>)targetLib.getTargets()), Zone.EXILED, source, game);
                }
                targetPlayer.shuffleLibrary(source, game);
                if (handCards > 0) {
                    targetPlayer.drawCards(handCards, source, game);
                }
            }
            return true;
        }
        return false;
    }
}

