/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.turn;

import java.util.UUID;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.common.LoseGameSourceControllerEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;

class LoseGameDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private final UUID turnId;

    public LoseGameDelayedTriggeredAbility(UUID turnId) {
        super(new LoseGameSourceControllerEffect(), Duration.EndOfGame);
        this.turnId = turnId;
    }

    protected LoseGameDelayedTriggeredAbility(LoseGameDelayedTriggeredAbility ability) {
        super(ability);
        this.turnId = ability.turnId;
    }

    @Override
    public LoseGameDelayedTriggeredAbility copy() {
        return new LoseGameDelayedTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.END_TURN_STEP_PRE;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        return this.turnId != null && this.turnId.equals(game.getState().getExtraTurnId());
    }

    @Override
    public String getRule() {
        return "At the beginning of that turn's end step, you lose the game";
    }
}

