/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.keyword;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.Effects;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.mageobject.ToughnessPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

public class BolsterEffect
extends OneShotEffect {
    private final DynamicValue amount;
    private Effects additionalEffects = new Effects(new Effect[0]);

    public BolsterEffect(int amount) {
        this(StaticValue.get(amount));
    }

    public BolsterEffect(DynamicValue amount) {
        super(Outcome.BoostCreature);
        this.amount = amount;
        this.staticText = this.setText();
    }

    protected BolsterEffect(BolsterEffect effect) {
        super(effect);
        this.amount = effect.amount;
        this.additionalEffects = effect.additionalEffects.copy();
    }

    @Override
    public BolsterEffect copy() {
        return new BolsterEffect(this);
    }

    public BolsterEffect withAdditionalEffect(Effect effect) {
        this.additionalEffects.add(effect);
        return this;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        if (this.amount.calculate(game, source, this) <= 0) {
            return true;
        }
        int leastToughness = Integer.MAX_VALUE;
        Permanent selectedCreature = null;
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents(StaticFilters.FILTER_PERMANENT_CREATURE, controller.getId(), game)) {
            if (leastToughness > permanent.getToughness().getValue()) {
                leastToughness = permanent.getToughness().getValue();
                selectedCreature = permanent;
                continue;
            }
            if (leastToughness != permanent.getToughness().getValue()) continue;
            leastToughness = permanent.getToughness().getValue();
            selectedCreature = null;
        }
        if (leastToughness == Integer.MAX_VALUE) {
            return false;
        }
        if (selectedCreature == null) {
            FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("creature you control with toughness " + leastToughness);
            filter.add(new ToughnessPredicate(ComparisonType.EQUAL_TO, leastToughness));
            TargetPermanent target = new TargetPermanent(1, 1, filter, true);
            if (controller.chooseTarget(this.outcome, target, source, game)) {
                selectedCreature = game.getPermanent(target.getFirstTarget());
            }
        }
        if (selectedCreature == null) {
            return false;
        }
        AddCountersTargetEffect effect = new AddCountersTargetEffect(CounterType.P1P1.createInstance(this.amount.calculate(game, source, this)));
        FixedTarget blueprintTarget = new FixedTarget(selectedCreature, game);
        effect.setTargetPointer(blueprintTarget.copy());
        effect.apply(game, source);
        if (!this.additionalEffects.isEmpty()) {
            for (Effect additionalEffect : this.additionalEffects) {
                additionalEffect.setTargetPointer(blueprintTarget.copy());
                if (additionalEffect instanceof OneShotEffect) {
                    additionalEffect.apply(game, source);
                    continue;
                }
                game.addEffect((ContinuousEffect)additionalEffect, source);
            }
        }
        return true;
    }

    private String setText() {
        if (this.amount instanceof StaticValue) {
            int number = ((StaticValue)this.amount).getValue();
            return "bolster " + number + ". <i>(Choose a creature with the least toughness among creatures you control and put " + CardUtil.numberToText(number, "a") + " +1/+1 counter" + (number == 1 ? "" : "s") + " on it.)</i>";
        }
        return "bolster X, where X is the number of " + this.amount.getMessage() + ". <i>(Choose a creature with the least toughness among creatures you control and put X +1/+1 counters on it.)</i>";
    }
}

