/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.keyword;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.ExploreEvent;
import mage.game.events.ExploredEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

public class ExploreSourceEffect
extends OneShotEffect {
    private final DynamicValue amount;
    private static final String REMINDER_TEXT = ". <i>(Reveal the top card of your library. Put that card into your hand if it's a land. Otherwise, put a +1/+1 counter on this creature, then put the card back or put it into your graveyard.)</i>";

    public ExploreSourceEffect() {
        this(true, "it");
    }

    public ExploreSourceEffect(boolean showAbilityHint, String explorerText) {
        this(1, showAbilityHint, explorerText);
    }

    public ExploreSourceEffect(int amount, boolean showAbilityHint, String explorerText) {
        this(StaticValue.get(amount), showAbilityHint, explorerText);
    }

    public ExploreSourceEffect(DynamicValue amount, boolean showAbilityHint, String explorerText) {
        super(Outcome.Benefit);
        this.amount = amount;
        this.staticText = "{this} explores" + (showAbilityHint ? REMINDER_TEXT : "");
    }

    protected ExploreSourceEffect(ExploreSourceEffect effect) {
        super(effect);
        this.amount = effect.amount;
    }

    @Override
    public ExploreSourceEffect copy() {
        return new ExploreSourceEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return ExploreSourceEffect.explorePermanent(game, source.getSourceId(), source, this.amount.calculate(game, source, this));
    }

    public static boolean explorePermanent(Game game, UUID permanentId, Ability source, int amount) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanentOrLKIBattlefield(permanentId);
        if (controller == null || permanent == null || amount <= 0) {
            return false;
        }
        ExploreEvent event = new ExploreEvent(permanent, source, amount);
        if (game.replaceEvent(event)) {
            return false;
        }
        block4: for (GameEvent.EventType eventType : event.getEventQueue()) {
            switch (eventType) {
                case SCRY: {
                    controller.scry(1, source, game);
                    continue block4;
                }
                case EXPLORE: {
                    ExploreSourceEffect.doOneExplore(game, permanent, source, controller);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Wrong code usage: unrecognized event type in explore event");
        }
        return true;
    }

    private static void doOneExplore(Game game, Permanent permanent, Ability source, Player controller) {
        Card card = controller.getLibrary().getFromTop(game);
        if (card != null) {
            controller.revealCards("Explored card", (Cards)new CardsImpl(card), game);
            if (card.isLand(game)) {
                controller.moveCards(card, Zone.HAND, source, game);
            } else {
                ExploreSourceEffect.addCounter(game, permanent, source);
                if (controller.chooseUse(Outcome.Neutral, "Put " + card.getLogName() + " in your graveyard?", source, game)) {
                    controller.moveCards(card, Zone.GRAVEYARD, source, game);
                } else {
                    game.informPlayers(controller.getLogName() + " leaves " + card.getLogName() + " on top of their library.");
                }
            }
        } else {
            ExploreSourceEffect.addCounter(game, permanent, source);
        }
        game.processAction();
        game.fireEvent(new ExploredEvent(permanent, source, card));
    }

    private static void addCounter(Game game, Permanent permanent, Ability source) {
        if (game.getState().getZone(permanent.getId()) == Zone.BATTLEFIELD) {
            permanent.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
        }
    }
}

