/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.keyword;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class ScryTargetEffect
extends OneShotEffect {
    protected final DynamicValue amount;

    public ScryTargetEffect(int amount) {
        this(StaticValue.get(amount));
    }

    public ScryTargetEffect(DynamicValue amount) {
        super(Outcome.Benefit);
        this.amount = amount;
    }

    protected ScryTargetEffect(ScryTargetEffect effect) {
        super(effect);
        this.amount = effect.amount;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        for (UUID playerId : this.getTargetPointer().getTargets(game, source)) {
            Player player = game.getPlayer(playerId);
            if (player == null || !player.canRespond()) continue;
            int toScry = this.amount.calculate(game, source, this);
            player.scry(toScry, source, game);
        }
        return true;
    }

    @Override
    public ScryTargetEffect copy() {
        return new ScryTargetEffect(this);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder(this.getTargetPointer().describeTargets(mode.getTargets(), "that player"));
        sb.append(" scries ");
        sb.append(CardUtil.numberToText(this.amount.toString()));
        return sb.toString();
    }
}

