/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.mana;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.builder.ConditionalManaBuilder;
import mage.choices.ManaChoice;
import mage.game.Game;
import mage.players.Player;

public class AddConditionalManaOfTwoDifferentColorsEffect
extends ManaEffect {
    private final ConditionalManaBuilder manaBuilder;

    public AddConditionalManaOfTwoDifferentColorsEffect(ConditionalManaBuilder manaBuilder) {
        this.manaBuilder = manaBuilder;
        this.staticText = "Add two mana of different colors. " + manaBuilder.getRule();
    }

    private AddConditionalManaOfTwoDifferentColorsEffect(AddConditionalManaOfTwoDifferentColorsEffect effect) {
        super(effect);
        this.manaBuilder = effect.manaBuilder;
    }

    @Override
    public List<Mana> getNetMana(Game game, Ability source) {
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        netMana.add(Mana.AnyMana(2));
        return netMana;
    }

    @Override
    public Mana produceMana(Game game, Ability source) {
        if (game != null) {
            Player player = this.getPlayer(game, source);
            Mana mana = (Mana)this.manaBuilder.setMana(ManaChoice.chooseTwoDifferentColors(player, game), source, game).build(new Object[0]);
            return mana;
        }
        return new Mana();
    }

    @Override
    public AddConditionalManaOfTwoDifferentColorsEffect copy() {
        return new AddConditionalManaOfTwoDifferentColorsEffect(this);
    }
}

